"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def deregister(hub, ctx, webhook_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Removes the connection between the webhook that was created by CodePipeline and the external tool with events to be detected. Currently supported only for webhooks that target an action type of GitHub.

    Args:
        webhook_name(str, optional): The name of the webhook you want to deregister. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.webhook.with_third_party.deregister(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.webhook.with_third_party.deregister
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="deregister_webhook_with_third_party",
        op_kwargs={"webhookName": webhook_name},
    )


async def register(hub, ctx, webhook_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Configures a connection between the webhook that was created and the external tool with events to be detected.

    Args:
        webhook_name(str, optional): The name of an existing webhook created with PutWebhook to register with a supported third party. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.webhook.with_third_party.register(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.webhook.with_third_party.register
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="register_webhook_with_third_party",
        op_kwargs={"webhookName": webhook_name},
    )
