"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub,
    ctx,
    job_id: str,
    client_token: str,
    current_revision: Dict = None,
    continuation_token: str = None,
    execution_details: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Represents the success of a third party job as returned to the pipeline by a job worker. Used for partner actions only.

    Args:
        job_id(str): The ID of the job that successfully completed. This is the same ID returned from PollForThirdPartyJobs.
        client_token(str): The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.
        current_revision(Dict, optional): Represents information about a current revision. Defaults to None.
        continuation_token(str, optional): A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a partner action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the partner action. When the action is complete, no continuation token should be supplied. Defaults to None.
        execution_details(Dict, optional): The details of the actions taken and results produced on an artifact as it passes through stages in the pipeline. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.third_party_job.success_result.put(
                ctx, job_id=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.third_party_job.success_result.put job_id=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="put_third_party_job_success_result",
        op_kwargs={
            "jobId": job_id,
            "clientToken": client_token,
            "currentRevision": current_revision,
            "continuationToken": continuation_token,
            "executionDetails": execution_details,
        },
    )
