"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def acknowledge(hub, ctx, job_id: str, nonce: str, client_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Confirms a job worker has received the specified job. Used for partner actions only.

    Args:
        job_id(str): The unique system-generated ID of the job.
        nonce(str): A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response to a GetThirdPartyJobDetails request.
        client_token(str): The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.third_party_job.init.acknowledge(
                ctx, job_id=value, nonce=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.third_party_job.init.acknowledge job_id=value, nonce=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="acknowledge_third_party_job",
        op_kwargs={"jobId": job_id, "nonce": nonce, "clientToken": client_token},
    )
