"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(hub, ctx, job_id: str, client_token: str, failure_details: Dict) -> None:
    r"""
    **Autogenerated function**

    Represents the failure of a third party job as returned to the pipeline by a job worker. Used for partner actions only.

    Args:
        job_id(str): The ID of the job that failed. This is the same ID returned from PollForThirdPartyJobs.
        client_token(str): The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.
        failure_details(Dict): Represents information about failure details.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.third_party_job.failure_result.put(
                ctx, job_id=value, client_token=value, failure_details=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.third_party_job.failure_result.put job_id=value, client_token=value, failure_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="put_third_party_job_failure_result",
        op_kwargs={
            "jobId": job_id,
            "clientToken": client_token,
            "failureDetails": failure_details,
        },
    )
