"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, job_id: str, client_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Requests the details of a job for a third party action. Used for partner actions only.  When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.

    Args:
        job_id(str): The unique system-generated ID used for identifying the job.
        client_token(str): The clientToken portion of the clientId and clientToken pair used to verify that the calling entity is allowed access to the job and its details.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.third_party_job.detail.get_all(
                ctx, job_id=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.third_party_job.detail.get_all job_id=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="get_third_party_job_details",
        op_kwargs={"jobId": job_id, "clientToken": client_token},
    )
