"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def disable(
    hub, ctx, pipeline_name: str, stage_name: str, transition_type: str, reason: str
) -> None:
    r"""
    **Autogenerated function**

    Prevents artifacts in a pipeline from transitioning to the next stage in the pipeline.

    Args:
        pipeline_name(str): The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
        stage_name(str): The name of the stage where you want to disable the inbound or outbound transition of artifacts.
        transition_type(str): Specifies whether artifacts are prevented from transitioning into the stage and being processed by the actions in that stage (inbound), or prevented from transitioning from the stage after they have been processed by the actions in that stage (outbound).
        reason(str): The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This message is displayed in the pipeline console UI.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.stage.transition.disable(
                ctx, pipeline_name=value, stage_name=value, transition_type=value, reason=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.stage.transition.disable pipeline_name=value, stage_name=value, transition_type=value, reason=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="disable_stage_transition",
        op_kwargs={
            "pipelineName": pipeline_name,
            "stageName": stage_name,
            "transitionType": transition_type,
            "reason": reason,
        },
    )


async def enable(
    hub, ctx, pipeline_name: str, stage_name: str, transition_type: str
) -> None:
    r"""
    **Autogenerated function**

    Enables artifacts in a pipeline to transition to a stage in a pipeline.

    Args:
        pipeline_name(str): The name of the pipeline in which you want to enable the flow of artifacts from one stage to another.
        stage_name(str): The name of the stage where you want to enable the transition of artifacts, either into the stage (inbound) or from that stage to the next stage (outbound).
        transition_type(str): Specifies whether artifacts are allowed to enter the stage and be processed by the actions in that stage (inbound) or whether already processed artifacts are allowed to transition to the next stage (outbound).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.stage.transition.enable(
                ctx, pipeline_name=value, stage_name=value, transition_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.stage.transition.enable pipeline_name=value, stage_name=value, transition_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="enable_stage_transition",
        op_kwargs={
            "pipelineName": pipeline_name,
            "stageName": stage_name,
            "transitionType": transition_type,
        },
    )
