"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, pipeline: Dict, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a pipeline.  In the pipeline structure, you must include either artifactStore or artifactStores in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use artifactStores.

    Args:
        pipeline(Dict): Represents the structure of actions and stages to be performed in the pipeline. .
        tags(List, optional): The tags for the pipeline. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.init.create(ctx, pipeline=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.init.create pipeline=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="create_pipeline",
        op_kwargs={"pipeline": pipeline, "tags": tags},
    )


async def delete(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified pipeline.

    Args:
        name(str): The name of the pipeline to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="delete_pipeline",
        op_kwargs={"name": name},
    )


async def get(hub, ctx, name: str, version: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the metadata, structure, stages, and actions of a pipeline. Can be used to return the entire structure of a pipeline in JSON format, which can then be modified and used to update the pipeline structure with UpdatePipeline.

    Args:
        name(str): The name of the pipeline for which you want to get information. Pipeline names must be unique under an AWS user account.
        version(int, optional): The version number of the pipeline. If you do not specify a version, defaults to the current version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="get_pipeline",
        op_kwargs={"name": name, "version": version},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a summary of all of the pipelines associated with your account.

    Args:
        next_token(str, optional): An identifier that was returned from the previous list pipelines call. It can be used to return the next set of pipelines in the list. Defaults to None.
        max_results(int, optional): The maximum number of pipelines to return in a single call. To retrieve the remaining pipelines, make another call with the returned nextToken value. The minimum value you can specify is 1. The maximum accepted value is 1000. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="list_pipelines",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(hub, ctx, pipeline: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates a specified pipeline with edits or changes to its structure. Use a JSON file with the pipeline structure and UpdatePipeline to provide the full structure of the pipeline. Updating the pipeline increases the version number of the pipeline by 1.

    Args:
        pipeline(Dict): The name of the pipeline to be updated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.init.update(ctx, pipeline=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.init.update pipeline=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="update_pipeline",
        op_kwargs={"pipeline": pipeline},
    )
