"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, pipeline_name: str, pipeline_execution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about an execution of a pipeline, including details about artifacts, the pipeline execution ID, and the name, version, and status of the pipeline.

    Args:
        pipeline_name(str): The name of the pipeline about which you want to get execution details.
        pipeline_execution_id(str): The ID of the pipeline execution about which you want to get execution details.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.execution.get(
                ctx, pipeline_name=value, pipeline_execution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.execution.get pipeline_name=value, pipeline_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="get_pipeline_execution",
        op_kwargs={
            "pipelineName": pipeline_name,
            "pipelineExecutionId": pipeline_execution_id,
        },
    )


async def list_all(
    hub, ctx, pipeline_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a summary of the most recent executions for a pipeline.

    Args:
        pipeline_name(str): The name of the pipeline for which you want to get execution summary information.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Pipeline history is limited to the most recent 12 months, based on pipeline execution start times. Default value is 100. Defaults to None.
        next_token(str, optional): The token that was returned from the previous ListPipelineExecutions call, which can be used to return the next set of pipeline executions in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.execution.list_all(
                ctx, pipeline_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.execution.list_all pipeline_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="list_pipeline_executions",
        op_kwargs={
            "pipelineName": pipeline_name,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(hub, ctx, name: str, client_request_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Starts the specified pipeline. Specifically, it begins processing the latest commit to the source location specified as part of the pipeline.

    Args:
        name(str): The name of the pipeline to start.
        client_request_token(str, optional): The system-generated unique ID used to identify a unique execution request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.execution.start(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.execution.start name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="start_pipeline_execution",
        op_kwargs={"name": name, "clientRequestToken": client_request_token},
    )


async def stop(
    hub,
    ctx,
    pipeline_name: str,
    pipeline_execution_id: str,
    abandon: bool = None,
    reason: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Stops the specified pipeline execution. You choose to either stop the pipeline execution by completing in-progress actions without starting subsequent actions, or by abandoning in-progress actions. While completing or abandoning in-progress actions, the pipeline execution is in a Stopping state. After all in-progress actions are completed or abandoned, the pipeline execution is in a Stopped state.

    Args:
        pipeline_name(str): The name of the pipeline to stop.
        pipeline_execution_id(str): The ID of the pipeline execution to be stopped in the current stage. Use the GetPipelineState action to retrieve the current pipelineExecutionId.
        abandon(bool, optional): Use this option to stop the pipeline execution by abandoning, rather than finishing, in-progress actions.  This option can lead to failed or out-of-sequence tasks. . Defaults to None.
        reason(str, optional): Use this option to enter comments, such as the reason the pipeline was stopped. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.pipeline.execution.stop(
                ctx, pipeline_name=value, pipeline_execution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.pipeline.execution.stop pipeline_name=value, pipeline_execution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="stop_pipeline_execution",
        op_kwargs={
            "pipelineName": pipeline_name,
            "pipelineExecutionId": pipeline_execution_id,
            "abandon": abandon,
            "reason": reason,
        },
    )
