"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub,
    ctx,
    job_id: str,
    current_revision: Dict = None,
    continuation_token: str = None,
    execution_details: Dict = None,
    output_variables: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Represents the success of a job as returned to the pipeline by a job worker. Used for custom actions only.

    Args:
        job_id(str): The unique system-generated ID of the job that succeeded. This is the same ID returned from PollForJobs.
        current_revision(Dict, optional): The ID of the current revision of the artifact successfully worked on by the job. Defaults to None.
        continuation_token(str, optional): A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to identify a custom action in progress. Future jobs use this token to identify the running instance of the action. It can be reused to return more information about the progress of the custom action. When the action is complete, no continuation token should be supplied. Defaults to None.
        execution_details(Dict, optional): The execution details of the successful job, such as the actions taken by the job worker. Defaults to None.
        output_variables(Dict, optional): Key-value pairs produced as output by a job worker that can be made available to a downstream action configuration. outputVariables can be included only when there is no continuation token on the request. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.job.success_result.put(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.job.success_result.put job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="put_job_success_result",
        op_kwargs={
            "jobId": job_id,
            "currentRevision": current_revision,
            "continuationToken": continuation_token,
            "executionDetails": execution_details,
            "outputVariables": output_variables,
        },
    )
