"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def acknowledge(hub, ctx, job_id: str, nonce: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specified job and whether that job has been received by the job worker. Used for custom actions only.

    Args:
        job_id(str): The unique system-generated ID of the job for which you want to confirm receipt.
        nonce(str): A system-generated random number that AWS CodePipeline uses to ensure that the job is being worked on by only one job worker. Get this number from the response of the PollForJobs request that returned this job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.job.init.acknowledge(
                ctx, job_id=value, nonce=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.job.init.acknowledge job_id=value, nonce=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="acknowledge_job",
        op_kwargs={"jobId": job_id, "nonce": nonce},
    )
