"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(hub, ctx, job_id: str, failure_details: Dict) -> None:
    r"""
    **Autogenerated function**

    Represents the failure of a job as returned to the pipeline by a job worker. Used for custom actions only.

    Args:
        job_id(str): The unique system-generated ID of the job that failed. This is the same ID returned from PollForJobs.
        failure_details(Dict): The details about the failure of a job.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.job.failure_result.put(
                ctx, job_id=value, failure_details=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.job.failure_result.put job_id=value, failure_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="put_job_failure_result",
        op_kwargs={"jobId": job_id, "failureDetails": failure_details},
    )
