"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def poll(hub, ctx, action_type_id: Dict, max_batch_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Determines whether there are any third party jobs for a job worker to act on. Used for partner actions only.  When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts.

    Args:
        action_type_id(Dict): Represents information about an action type.
        max_batch_size(int, optional): The maximum number of jobs to return in a poll for jobs call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.for_.third_party_job.poll(
                ctx, action_type_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.for_.third_party_job.poll action_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="poll_for_third_party_jobs",
        op_kwargs={"actionTypeId": action_type_id, "maxBatchSize": max_batch_size},
    )
