"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def poll(
    hub, ctx, action_type_id: Dict, max_batch_size: int = None, query_param: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about any jobs for AWS CodePipeline to act on. PollForJobs is valid only for action types with "Custom" in the owner field. If the action type contains "AWS" or "ThirdParty" in the owner field, the PollForJobs action returns an error.  When this API is called, AWS CodePipeline returns temporary credentials for the S3 bucket used to store artifacts for the pipeline, if the action requires access to that S3 bucket for input or output artifacts. This API also returns any secret values defined for the action.

    Args:
        action_type_id(Dict): Represents information about an action type.
        max_batch_size(int, optional): The maximum number of jobs to return in a poll for jobs call. Defaults to None.
        query_param(Dict, optional): A map of property names and values. For an action type with no queryable properties, this value must be null or an empty map. For an action type with a queryable property, you must supply that property as a key in the map. Only jobs whose action configuration matches the mapped value are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.for_.job.poll(ctx, action_type_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.for_.job.poll action_type_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="poll_for_jobs",
        op_kwargs={
            "actionTypeId": action_type_id,
            "maxBatchSize": max_batch_size,
            "queryParam": query_param,
        },
    )
