"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "custom_action_type"


async def create(
    hub,
    ctx,
    category: str,
    provider: str,
    version: str,
    input_artifact_details: Dict,
    output_artifact_details: Dict,
    settings: Dict = None,
    configuration_properties: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new custom action that can be used in all pipelines associated with the AWS account. Only used for custom actions.

    Args:
        category(str): The category of the custom action, such as a build action or a test action.
        provider(str): The provider of the service used in the custom action, such as AWS CodeDeploy.
        version(str): The version identifier of the custom action.
        settings(Dict, optional): URLs that provide users information about this custom action. Defaults to None.
        configuration_properties(List, optional): The configuration properties for the custom action.  You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see Create a Custom Action for a Pipeline. . Defaults to None.
        input_artifact_details(Dict): The details of the input artifact for the action, such as its commit ID.
        output_artifact_details(Dict): The details of the output artifact of the action, such as its commit ID.
        tags(List, optional): The tags for the custom action. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.custom_action_type_.create(
                ctx,
                category=value,
                provider=value,
                version=value,
                input_artifact_details=value,
                output_artifact_details=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.custom_action_type.create category=value, provider=value, version=value, input_artifact_details=value, output_artifact_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="create_custom_action_type",
        op_kwargs={
            "category": category,
            "provider": provider,
            "version": version,
            "settings": settings,
            "configurationProperties": configuration_properties,
            "inputArtifactDetails": input_artifact_details,
            "outputArtifactDetails": output_artifact_details,
            "tags": tags,
        },
    )


async def delete(hub, ctx, category: str, provider: str, version: str) -> None:
    r"""
    **Autogenerated function**

    Marks a custom action as deleted. PollForJobs for the custom action fails after the action is marked for deletion. Used for custom actions only.  To re-create a custom action after it has been deleted you must use a string in the version field that has never been used before. This string can be an incremented version number, for example. To restore a deleted custom action, use a JSON file that is identical to the deleted action, including the original string in the version field.

    Args:
        category(str): The category of the custom action that you want to delete, such as source or deploy.
        provider(str): The provider of the service used in the custom action, such as AWS CodeDeploy.
        version(str): The version of the custom action to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.custom_action_type_.delete(
                ctx, category=value, provider=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.custom_action_type.delete category=value, provider=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="delete_custom_action_type",
        op_kwargs={"category": category, "provider": provider, "version": version},
    )
