"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub,
    ctx,
    pipeline_name: str,
    stage_name: str,
    action_name: str,
    result: Dict,
    token: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides the response to a manual approval request to AWS CodePipeline. Valid responses include Approved and Rejected.

    Args:
        pipeline_name(str): The name of the pipeline that contains the action. .
        stage_name(str): The name of the stage that contains the action.
        action_name(str): The name of the action for which approval is requested.
        result(Dict): Represents information about the result of the approval request.
        token(str): The system-generated token used to identify a unique approval request. The token for each open approval request can be obtained using the GetPipelineState action. It is used to validate that the approval request corresponding to this token is still valid.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.approval_result.put(
                ctx,
                pipeline_name=value,
                stage_name=value,
                action_name=value,
                result=value,
                token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.approval_result.put pipeline_name=value, stage_name=value, action_name=value, result=value, token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="put_approval_result",
        op_kwargs={
            "pipelineName": pipeline_name,
            "stageName": stage_name,
            "actionName": action_name,
            "result": result,
            "token": token,
        },
    )
