"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def get(hub, ctx, category: str, owner: str, provider: str, version: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about an action type created for an external provider, where the action is to be used by customers of the external provider. The action can be created with any supported integration model.

    Args:
        category(str): Defines what kind of action can be taken in the stage. The following are the valid values:    Source     Build     Test     Deploy     Approval     Invoke   .
        owner(str): The creator of an action type that was created with any supported integration model. There are two valid values: AWS and ThirdParty.
        provider(str): The provider of the action type being called. The provider name is specified when the action type is created.
        version(str): A string that describes the action type version.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.action.type_.get(
                ctx, category=value, owner=value, provider=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.action.type.get category=value, owner=value, provider=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="get_action_type",
        op_kwargs={
            "category": category,
            "owner": owner,
            "provider": provider,
            "version": version,
        },
    )


async def list_all(
    hub,
    ctx,
    action_owner_filter: str = None,
    next_token: str = None,
    region_filter: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a summary of all AWS CodePipeline action types associated with your account.

    Args:
        action_owner_filter(str, optional): Filters the list of action types to those created by a specified entity. Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous list action types call, which can be used to return the next set of action types in the list. Defaults to None.
        region_filter(str, optional): The Region to filter on for the list of action types. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.action.type_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.action.type.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="list_action_types",
        op_kwargs={
            "actionOwnerFilter": action_owner_filter,
            "nextToken": next_token,
            "regionFilter": region_filter,
        },
    )


async def update(hub, ctx, action_type: Dict) -> None:
    r"""
    **Autogenerated function**

    Updates an action type that was created with any supported integration model, where the action type is to be used by customers of the action type provider. Use a JSON file with the action definition and UpdateActionType to provide the full structure.

    Args:
        action_type(Dict): The action type definition for the action type to be updated.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.action.type_.update(ctx, action_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.action.type.update action_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="update_action_type",
        op_kwargs={"actionType": action_type},
    )
