"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub,
    ctx,
    pipeline_name: str,
    stage_name: str,
    action_name: str,
    action_revision: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides information to AWS CodePipeline about new revisions to a source.

    Args:
        pipeline_name(str): The name of the pipeline that starts processing the revision to the source.
        stage_name(str): The name of the stage that contains the action that acts on the revision.
        action_name(str): The name of the action that processes the revision.
        action_revision(Dict): Represents information about the version (or revision) of an action.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.action.revision.put(
                ctx, pipeline_name=value, stage_name=value, action_name=value, action_revision=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.action.revision.put pipeline_name=value, stage_name=value, action_name=value, action_revision=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="put_action_revision",
        op_kwargs={
            "pipelineName": pipeline_name,
            "stageName": stage_name,
            "actionName": action_name,
            "actionRevision": action_revision,
        },
    )
