"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    pipeline_name: str,
    filter_: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the action executions that have occurred in a pipeline.

    Args:
        pipeline_name(str):  The name of the pipeline for which you want to list action execution history.
        filter_(Dict, optional): Input information used to filter action execution history. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Action execution history is retained for up to 12 months, based on action execution start times. Default value is 100.   Detailed execution history is available for executions run on or after February 21, 2019. . Defaults to None.
        next_token(str, optional): The token that was returned from the previous ListActionExecutions call, which can be used to return the next set of action executions in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codepipeline.action.execution.list_all(ctx, pipeline_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codepipeline.action.execution.list_all pipeline_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codepipeline",
        operation="list_action_executions",
        op_kwargs={
            "pipelineName": pipeline_name,
            "filter": filter_,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
