"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    client_token: str,
    profiling_group_name: str,
    agent_orchestration_config: Dict = None,
    compute_platform: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a profiling group.

    Args:
        agent_orchestration_config(Dict, optional):  Specifies whether profiling is enabled or disabled for the created profiling group. . Defaults to None.
        client_token(str):  Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental creation of duplicate profiling groups if there are failures and retries. .
        compute_platform(str, optional):  The compute platform of the profiling group. Use AWSLambda if your application runs on AWS Lambda. Use Default if your application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified, Default is used. . Defaults to None.
        profiling_group_name(str): The name of the profiling group to create.
        tags(Dict, optional):  A list of tags to add to the created profiling group. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.profiling_group.create(
                ctx, client_token=value, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.profiling_group.create client_token=value, profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="create_profiling_group",
        op_kwargs={
            "agentOrchestrationConfig": agent_orchestration_config,
            "clientToken": client_token,
            "computePlatform": compute_platform,
            "profilingGroupName": profiling_group_name,
            "tags": tags,
        },
    )


async def delete(hub, ctx, profiling_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a profiling group.

    Args:
        profiling_group_name(str): The name of the profiling group to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.profiling_group.delete(
                ctx, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.profiling_group.delete profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="delete_profiling_group",
        op_kwargs={"profilingGroupName": profiling_group_name},
    )


async def describe(hub, ctx, profiling_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns a  ProfilingGroupDescription  object that contains information about the requested profiling group.

    Args:
        profiling_group_name(str):  The name of the profiling group to get information about. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.profiling_group.describe(
                ctx, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.profiling_group.describe profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="describe_profiling_group",
        op_kwargs={"profilingGroupName": profiling_group_name},
    )


async def list_all(
    hub,
    ctx,
    include_description: bool = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of profiling groups. The profiling groups are returned as  ProfilingGroupDescription  objects.

    Args:
        include_description(bool, optional): A Boolean value indicating whether to include a description. If true, then a list of  ProfilingGroupDescription  objects that contain detailed information about profiling groups is returned. If false, then a list of profiling group names is returned. Defaults to None.
        max_results(int, optional): The maximum number of profiling groups results returned by ListProfilingGroups in paginated output. When this parameter is used, ListProfilingGroups only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListProfilingGroups request with the returned nextToken value. . Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListProfilingGroups request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value.   This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.profiling_group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.profiling_group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="list_profiling_groups",
        op_kwargs={
            "includeDescription": include_description,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub, ctx, agent_orchestration_config: Dict, profiling_group_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a profiling group.

    Args:
        agent_orchestration_config(Dict):  Specifies whether profiling is enabled or disabled for a profiling group. .
        profiling_group_name(str): The name of the profiling group to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.profiling_group.update(
                ctx, agent_orchestration_config=value, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.profiling_group.update agent_orchestration_config=value, profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="update_profiling_group",
        op_kwargs={
            "agentOrchestrationConfig": agent_orchestration_config,
            "profilingGroupName": profiling_group_name,
        },
    )
