"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    end_time: str,
    period: str,
    profiling_group_name: str,
    start_time: str,
    max_results: int = None,
    next_token: str = None,
    order_by: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.

    Args:
        end_time(str): The end time of the time range from which to list the profiles.
        max_results(int, optional): The maximum number of profile time results returned by ListProfileTimes in paginated output. When this parameter is used, ListProfileTimes only returns maxResults results in a single page with a nextToken response element. The remaining results of the initial request can be seen by sending another ListProfileTimes request with the returned nextToken value. . Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListProfileTimes request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value.   This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        order_by(str, optional): The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to TIMESTAMP_DESCENDING. . Defaults to None.
        period(str):  The aggregation period. This specifies the period during which an aggregation profile collects posted agent profiles for a profiling group. There are 3 valid values.     P1D — 1 day     PT1H — 1 hour     PT5M — 5 minutes   .
        profiling_group_name(str): The name of the profiling group.
        start_time(str): The start time of the time range from which to list the profiles.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.profile.time.list_all(
                ctx, end_time=value, period=value, profiling_group_name=value, start_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.profile.time.list_all end_time=value, period=value, profiling_group_name=value, start_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="list_profile_times",
        op_kwargs={
            "endTime": end_time,
            "maxResults": max_results,
            "nextToken": next_token,
            "orderBy": order_by,
            "period": period,
            "profilingGroupName": profiling_group_name,
            "startTime": start_time,
        },
    )
