"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, profiling_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns the JSON-formatted resource-based policy on a profiling group.

    Args:
        profiling_group_name(str): The name of the profiling group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.policy.get(ctx, profiling_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.policy.get profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="get_policy",
        op_kwargs={"profilingGroupName": profiling_group_name},
    )
