"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put(
    hub,
    ctx,
    action_group: str,
    principals: List,
    profiling_group_name: str,
    revision_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action group and the roles and users in the principals parameter.   <p> The one supported action group that can be added is <code>agentPermission</code> which grants <code>ConfigureAgent</code> and <code>PostAgent</code> permissions. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler</a> in the <i>Amazon CodeGuru Profiler User Guide</i>, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code> </a>, and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html"> <code>PostAgentProfile</code> </a>. </p> <p> The first time you call <code>PutPermission</code> on a profiling group, do not specify a <code>revisionId</code> because it doesn't have a resource-based policy. Subsequent calls must provide a <code>revisionId</code> to specify which revision of the resource-based policy to add the permissions to. </p> <p> The response contains the profiling group's JSON-formatted resource policy. </p>

    Args:
        action_group(str):  Specifies an action group that contains permissions to add to a profiling group resource. One action group is supported, agentPermissions, which grants permission to perform actions required by the profiling agent, ConfigureAgent and PostAgentProfile permissions. .
        principals(List):  A list ARNs for the roles and users you want to grant access to the profiling group. Wildcards are not are supported in the ARNs. .
        profiling_group_name(str): The name of the profiling group to grant access to.
        revision_id(str, optional):  A universally unique identifier (UUID) for the revision of the policy you are adding to the profiling group. Do not specify this when you add permissions to a profiling group for the first time. If a policy already exists on the profiling group, you must specify the revisionId. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.permission.put(
                ctx, action_group=value, principals=value, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.permission.put action_group=value, principals=value, profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="put_permission",
        op_kwargs={
            "actionGroup": action_group,
            "principals": principals,
            "profilingGroupName": profiling_group_name,
            "revisionId": revision_id,
        },
    )


async def remove(
    hub, ctx, action_group: str, profiling_group_name: str, revision_id: str
) -> Dict:
    r"""
    **Autogenerated function**

     Removes permissions from a profiling group's resource-based policy that are provided using an action group. The one supported action group that can be removed is agentPermission which grants ConfigureAgent and PostAgent permissions. For more information, see Resource-based policies in CodeGuru Profiler in the Amazon CodeGuru Profiler User Guide,  ConfigureAgent , and  PostAgentProfile .

    Args:
        action_group(str):  Specifies an action group that contains the permissions to remove from a profiling group's resource-based policy. One action group is supported, agentPermissions, which grants ConfigureAgent and PostAgentProfile permissions. .
        profiling_group_name(str): The name of the profiling group.
        revision_id(str):  A universally unique identifier (UUID) for the revision of the resource-based policy from which you want to remove permissions. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.permission.remove(
                ctx, action_group=value, profiling_group_name=value, revision_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.permission.remove action_group=value, profiling_group_name=value, revision_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="remove_permission",
        op_kwargs={
            "actionGroup": action_group,
            "profilingGroupName": profiling_group_name,
            "revisionId": revision_id,
        },
    )
