"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, channels: List, profiling_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Add up to 2 anomaly notifications channels for a profiling group.

    Args:
        channels(List): One or 2 channels to report to when anomalies are detected.
        profiling_group_name(str): The name of the profiling group that we are setting up notifications for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.notification.channel.add(
                ctx, channels=value, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.notification.channel.add channels=value, profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="add_notification_channels",
        op_kwargs={"channels": channels, "profilingGroupName": profiling_group_name},
    )


async def remove(hub, ctx, channel_id: str, profiling_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Remove one anomaly notifications channel for a profiling group.

    Args:
        channel_id(str): The id of the channel that we want to stop receiving notifications.
        profiling_group_name(str): The name of the profiling group we want to change notification configuration for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.notification.channel.remove(
                ctx, channel_id=value, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.notification.channel.remove channel_id=value, profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="remove_notification_channel",
        op_kwargs={"channelId": channel_id, "profilingGroupName": profiling_group_name},
    )
