"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    profiling_group_name: str,
    end_time: str = None,
    frame_metrics: List = None,
    period: str = None,
    start_time: str = None,
    target_resolution: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the time series of values for a requested list of frame metrics from a time period.

    Args:
        end_time(str, optional):  The end time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. . Defaults to None.
        frame_metrics(List, optional):  The details of the metrics that are used to request a time series of values. The metric includes the name of the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to get the count for the metric value of the frame. Defaults to None.
        period(str, optional):  The duration of the frame metrics used to return the time series values. Specify using the ISO 8601 format. The maximum period duration is one day (PT24H or P1D). . Defaults to None.
        profiling_group_name(str):  The name of the profiling group associated with the the frame metrics used to return the time series values. .
        start_time(str, optional):  The start time of the time period for the frame metrics used to return the time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. . Defaults to None.
        target_resolution(str, optional): The requested resolution of time steps for the returned time series of values. If the requested target resolution is not available due to data not being retained we provide a best effort result by falling back to the most granular available resolution after the target resolution. There are 3 valid values.     P1D — 1 day     PT1H — 1 hour     PT5M — 5 minutes   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.get_frame_metric_data.batch(
                ctx, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.get_frame_metric_data.batch profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="batch_get_frame_metric_data",
        op_kwargs={
            "endTime": end_time,
            "frameMetrics": frame_metrics,
            "period": period,
            "profilingGroupName": profiling_group_name,
            "startTime": start_time,
            "targetResolution": target_resolution,
        },
    )
