"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    end_time: str,
    profiling_group_name: str,
    start_time: str,
    daily_reports_only: bool = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the available reports for a given profiling group and time range.

    Args:
        daily_reports_only(bool, optional): A Boolean value indicating whether to only return reports from daily profiles. If set to True, only analysis data from daily profiles is returned. If set to False, analysis data is returned from smaller time windows (for example, one hour). Defaults to None.
        end_time(str):  The end time of the profile to get analysis data about. You must specify startTime and endTime. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. .
        max_results(int, optional): The maximum number of report results returned by ListFindingsReports in paginated output. When this parameter is used, ListFindingsReports only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another ListFindingsReports request with the returned nextToken value. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated ListFindingsReportsRequest request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value.   This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.
        profiling_group_name(str): The name of the profiling group from which to search for analysis data.
        start_time(str):  The start time of the profile to get analysis data about. You must specify startTime and endTime. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.finding_report.init.list_all(
                ctx, end_time=value, profiling_group_name=value, start_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.finding_report.init.list_all end_time=value, profiling_group_name=value, start_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="list_findings_reports",
        op_kwargs={
            "dailyReportsOnly": daily_reports_only,
            "endTime": end_time,
            "maxResults": max_results,
            "nextToken": next_token,
            "profilingGroupName": profiling_group_name,
            "startTime": start_time,
        },
    )
