"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    daily_reports_only: bool = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of  FindingsReportSummary  objects that contain analysis results for all profiling groups in your AWS account.

    Args:
        daily_reports_only(bool, optional): A Boolean value indicating whether to only return reports from daily profiles. If set to True, only analysis data from daily profiles is returned. If set to False, analysis data is returned from smaller time windows (for example, one hour). Defaults to None.
        max_results(int, optional): The maximum number of results returned by  GetFindingsReportAccountSummary in paginated output. When this parameter is used, GetFindingsReportAccountSummary only returns maxResults results in a single page along with a nextToken response element. The remaining results of the initial request can be seen by sending another GetFindingsReportAccountSummary request with the returned nextToken value. Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous paginated GetFindingsReportAccountSummary request where maxResults was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the nextToken value.   This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.finding_report.account_summary.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.finding_report.account_summary.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="get_findings_report_account_summary",
        op_kwargs={
            "dailyReportsOnly": daily_reports_only,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
