"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def post(
    hub,
    ctx,
    agent_profile: bytes,
    content_type: str,
    profiling_group_name: str,
    profile_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is created with this profiling data, use  GetProfile .

    Args:
        agent_profile(bytes):  The submitted profiling data. .
        content_type(str):  The format of the submitted profiling data. The format maps to the Accept and Content-Type headers of the HTTP request. You can specify one of the following: or the default .   <ul> <li> <p> <code>application/json</code> — standard JSON format </p> </li> <li> <p> <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information, see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>. </p> </li> </ul> .
        profile_token(str, optional):  Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental submission of duplicate profiling data if there are failures and retries. . Defaults to None.
        profiling_group_name(str):  The name of the profiling group with the aggregated profile that receives the submitted profiling data. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguruprofiler.agent.profile.post(
                ctx, agent_profile=value, content_type=value, profiling_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguruprofiler.agent.profile.post agent_profile=value, content_type=value, profiling_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguruprofiler",
        operation="post_agent_profile",
        op_kwargs={
            "agentProfile": agent_profile,
            "contentType": content_type,
            "profileToken": profile_token,
            "profilingGroupName": profiling_group_name,
        },
    )
