"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    repository: Dict,
    client_request_token: str = None,
    tags: Dict = None,
    kms_key_details: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Use to associate an AWS CodeCommit repository or a repostory managed by AWS CodeStar Connections with Amazon CodeGuru Reviewer. When you associate a repository, CodeGuru Reviewer reviews source code changes in the repository's pull requests and provides automatic recommendations. You can view recommendations using the CodeGuru Reviewer console. For more information, see Recommendations in Amazon CodeGuru Reviewer in the Amazon CodeGuru Reviewer User Guide.  If you associate a CodeCommit or S3 repository, it must be in the same AWS Region and AWS account where its CodeGuru Reviewer code reviews are configured. Bitbucket and GitHub Enterprise Server repositories are managed by AWS CodeStar Connections to connect to CodeGuru Reviewer. For more information, see Associate a repository in the Amazon CodeGuru Reviewer User Guide.    You cannot use the CodeGuru Reviewer SDK or the AWS CLI to associate a GitHub repository with Amazon CodeGuru Reviewer. To associate a GitHub repository, use the console. For more information, see Getting started with CodeGuru Reviewer in the CodeGuru Reviewer User Guide.

    Args:
        repository(Dict): The repository to associate.
        client_request_token(str, optional): Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations if there are failures and retries. . Defaults to None.
        tags(Dict, optional):  An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:    A tag key (for example, CostCenter, Environment, Project, or Secret). Tag keys are case sensitive.   An optional field known as a tag value (for example, 111122223333, Production, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.  . Defaults to None.
        kms_key_details(Dict, optional): A KMSKeyDetails object that contains:   The encryption option for this repository association. It is either owned by AWS Key Management Service (KMS) (AWS_OWNED_CMK) or customer managed (CUSTOMER_MANAGED_CMK).   The ID of the AWS KMS key that is associated with this respository association.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.repository.init.associate(
                ctx, repository=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.repository.init.associate repository=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="associate_repository",
        op_kwargs={
            "Repository": repository,
            "ClientRequestToken": client_request_token,
            "Tags": tags,
            "KMSKeyDetails": kms_key_details,
        },
    )


async def disassociate(hub, ctx, association_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the association between Amazon CodeGuru Reviewer and a repository.

    Args:
        association_arn(str):  The Amazon Resource Name (ARN) of the  RepositoryAssociation  object. You can retrieve this ARN by calling  ListRepositoryAssociations . .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.repository.init.disassociate(
                ctx, association_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.repository.init.disassociate association_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="disassociate_repository",
        op_kwargs={"AssociationArn": association_arn},
    )
