"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, code_review_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the list of all recommendations for a completed code review.

    Args:
        next_token(str, optional):  Pagination token. . Defaults to None.
        max_results(int, optional):  The maximum number of results that are returned per call. The default is 100. . Defaults to None.
        code_review_arn(str): The Amazon Resource Name (ARN) of the  CodeReview  object. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.recommendation.init.list_all(
                ctx, code_review_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.recommendation.init.list_all code_review_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="list_recommendations",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "CodeReviewArn": code_review_arn,
        },
    )
