"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def describe(
    hub, ctx, code_review_arn: str, recommendation_id: str, user_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Describes the customer feedback for a CodeGuru Reviewer recommendation.

    Args:
        code_review_arn(str): The Amazon Resource Name (ARN) of the  CodeReview  object. .
        recommendation_id(str):  The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. .
        user_id(str, optional):  Optional parameter to describe the feedback for a given user. If this is not supplied, it defaults to the user making the request.   The UserId is an IAM principal that can be specified as an AWS account ID or an Amazon Resource Name (ARN). For more information, see  Specifying a Principal in the AWS Identity and Access Management User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.recommendation.feedback.describe(
                ctx, code_review_arn=value, recommendation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.recommendation.feedback.describe code_review_arn=value, recommendation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="describe_recommendation_feedback",
        op_kwargs={
            "CodeReviewArn": code_review_arn,
            "RecommendationId": recommendation_id,
            "UserId": user_id,
        },
    )


async def list_(
    hub,
    ctx,
    code_review_arn: str,
    next_token: str = None,
    max_results: int = None,
    user_ids: List = None,
    recommendation_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of  RecommendationFeedbackSummary  objects that contain customer recommendation feedback for all CodeGuru Reviewer users.

    Args:
        next_token(str, optional):  If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. . Defaults to None.
        max_results(int, optional):  The maximum number of results that are returned per call. The default is 100. . Defaults to None.
        code_review_arn(str): The Amazon Resource Name (ARN) of the  CodeReview  object. .
        user_ids(List, optional):  An AWS user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user.   The UserId is an IAM principal that can be specified as an AWS account ID or an Amazon Resource Name (ARN). For more information, see  Specifying a Principal in the AWS Identity and Access Management User Guide. . Defaults to None.
        recommendation_ids(List, optional):  Used to query the recommendation feedback for a given recommendation. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.recommendation.feedback.list(
                ctx, code_review_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.recommendation.feedback.list code_review_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="list_recommendation_feedback",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "CodeReviewArn": code_review_arn,
            "UserIds": user_ids,
            "RecommendationIds": recommendation_ids,
        },
    )


async def put(
    hub, ctx, code_review_arn: str, recommendation_id: str, reactions: List
) -> Dict:
    r"""
    **Autogenerated function**

     Stores customer feedback for a CodeGuru Reviewer recommendation. When this API is called again with different reactions the previous feedback is overwritten.

    Args:
        code_review_arn(str): The Amazon Resource Name (ARN) of the  CodeReview  object. .
        recommendation_id(str):  The recommendation ID that can be used to track the provided recommendations and then to collect the feedback. .
        reactions(List):  List for storing reactions. Reactions are utf-8 text code for emojis. If you send an empty list it clears all your feedback. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.recommendation.feedback.put(
                ctx, code_review_arn=value, recommendation_id=value, reactions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.recommendation.feedback.put code_review_arn=value, recommendation_id=value, reactions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="put_recommendation_feedback",
        op_kwargs={
            "CodeReviewArn": code_review_arn,
            "RecommendationId": recommendation_id,
            "Reactions": reactions,
        },
    )
