"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    repository_association_arn: str,
    type_: Dict,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Use to create a code review with a  CodeReviewType  of RepositoryAnalysis. This type of code review analyzes all code under a specified branch in an associated repository. PullRequest code reviews are automatically triggered by a pull request.

    Args:
        name(str):  The name of the code review. The name of each code review in your AWS account must be unique. .
        repository_association_arn(str):  The Amazon Resource Name (ARN) of the  RepositoryAssociation  object. You can retrieve this ARN by calling  ListRepositoryAssociations .   A code review can only be created on an associated repository. This is the ARN of the associated repository. .
        type_(Dict):  The type of code review to create. This is specified using a  CodeReviewType  object. You can create a code review only of type RepositoryAnalysis. .
        client_request_token(str, optional):  Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate code reviews if there are failures and retries. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.code_review.create(
                ctx, name=value, repository_association_arn=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.code_review.create name=value, repository_association_arn=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="create_code_review",
        op_kwargs={
            "Name": name,
            "RepositoryAssociationArn": repository_association_arn,
            "Type": type_,
            "ClientRequestToken": client_request_token,
        },
    )


async def describe(hub, ctx, code_review_arn: str) -> Dict:
    r"""
    **Autogenerated function**

     Returns the metadata associated with the code review along with its status.

    Args:
        code_review_arn(str): The Amazon Resource Name (ARN) of the  CodeReview  object. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.code_review.describe(
                ctx, code_review_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.code_review.describe code_review_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="describe_code_review",
        op_kwargs={"CodeReviewArn": code_review_arn},
    )


async def list_all(
    hub,
    ctx,
    type_: str,
    provider_types: List = None,
    states: List = None,
    repository_names: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Lists all the code reviews that the customer has created in the past 90 days.

    Args:
        provider_types(List, optional):  List of provider types for filtering that needs to be applied before displaying the result. For example, providerTypes=[GitHub] lists code reviews from GitHub. . Defaults to None.
        states(List, optional):  List of states for filtering that needs to be applied before displaying the result. For example, states=[Pending] lists code reviews in the Pending state.  The valid code review states are:    Completed: The code review is complete.     Pending: The code review started and has not completed or failed.     Failed: The code review failed.     Deleting: The code review is being deleted.   . Defaults to None.
        repository_names(List, optional):  List of repository names for filtering that needs to be applied before displaying the result. . Defaults to None.
        type_(str):  The type of code reviews to list in the response. .
        max_results(int, optional):  The maximum number of results that are returned per call. The default is 100. . Defaults to None.
        next_token(str, optional):  If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeguru_reviewer.code_review.list_all(ctx, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeguru_reviewer.code_review.list_all type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeguru-reviewer",
        operation="list_code_reviews",
        op_kwargs={
            "ProviderTypes": provider_types,
            "States": states,
            "RepositoryNames": repository_names,
            "Type": type_,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
