"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def skip(hub, ctx, deployment_id: str = None) -> None:
    r"""
    **Autogenerated function**

    In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.

    Args:
        deployment_id(str, optional):  The unique ID of a blue/green deployment for which you want to skip the instance termination wait time. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.wait_time_for_instance_termination.skip(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.wait_time_for_instance_termination.skip
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="skip_wait_time_for_instance_termination",
        op_kwargs={"deploymentId": deployment_id},
    )
