"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def add(hub, ctx, tags: List, instance_names: List) -> None:
    r"""
    **Autogenerated function**

    Adds tags to on-premises instances.

    Args:
        tags(List): The tag key-value pairs to add to the on-premises instances. Keys and values are both required. Keys cannot be null or empty strings. Value-only tags are not allowed.
        instance_names(List): The names of the on-premises instances to which to add tags.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.tags.to_on_premise_instance.add(
                ctx, tags=value, instance_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.tags.to_on_premise_instance.add tags=value, instance_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="add_tags_to_on_premises_instances",
        op_kwargs={"tags": tags, "instanceNames": instance_names},
    )
