"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def remove(hub, ctx, tags: List, instance_names: List) -> None:
    r"""
    **Autogenerated function**

    Removes one or more tags from one or more on-premises instances.

    Args:
        tags(List): The tag key-value pairs to remove from the on-premises instances.
        instance_names(List): The names of the on-premises instances from which to remove tags.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.tags.from_on_premise_instance.remove(
                ctx, tags=value, instance_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.tags.from_on_premise_instance.remove tags=value, instance_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="remove_tags_from_on_premises_instances",
        op_kwargs={"tags": tags, "instanceNames": instance_names},
    )
