"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "by_external_id"


async def delete(hub, ctx, external_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes resources linked to an external ID.

    Args:
        external_id(str, optional): The unique ID of an external resource (for example, a CloudFormation stack ID) that is linked to one or more CodeDeploy resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.resource.by_external_id_.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.resource.by_external_id.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="delete_resources_by_external_id",
        op_kwargs={"externalId": external_id},
    )
