"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(hub, ctx, instance_name: str) -> None:
    r"""
    **Autogenerated function**

    Deregisters an on-premises instance.

    Args:
        instance_name(str): The name of the on-premises instance to deregister.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.on_premise_instance.deregister(
                ctx, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.on_premise_instance.deregister instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="deregister_on_premises_instance",
        op_kwargs={"instanceName": instance_name},
    )


async def get(hub, ctx, instance_name: str) -> Dict:
    r"""
    **Autogenerated function**

     Gets information about an on-premises instance.

    Args:
        instance_name(str):  The name of the on-premises instance about which to get information. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.on_premise_instance.get(ctx, instance_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.on_premise_instance.get instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="get_on_premises_instance",
        op_kwargs={"instanceName": instance_name},
    )


async def list_all(
    hub,
    ctx,
    registration_status: str = None,
    tag_filters: List = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of names for one or more on-premises instances. Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.

    Args:
        registration_status(str, optional): The registration status of the on-premises instances:    Deregistered: Include deregistered on-premises instances in the resulting list.    Registered: Include registered on-premises instances in the resulting list.  . Defaults to None.
        tag_filters(List, optional): The on-premises instance tags that are used to restrict the on-premises instance names returned. Defaults to None.
        next_token(str, optional): An identifier returned from the previous list on-premises instances call. It can be used to return the next set of on-premises instances in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.on_premise_instance.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.on_premise_instance.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="list_on_premises_instances",
        op_kwargs={
            "registrationStatus": registration_status,
            "tagFilters": tag_filters,
            "nextToken": next_token,
        },
    )


async def register(
    hub, ctx, instance_name: str, iam_session_arn: str = None, iam_user_arn: str = None
) -> None:
    r"""
    **Autogenerated function**

    Registers an on-premises instance.  Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.

    Args:
        instance_name(str): The name of the on-premises instance to register.
        iam_session_arn(str, optional): The ARN of the IAM session to associate with the on-premises instance. Defaults to None.
        iam_user_arn(str, optional): The ARN of the IAM user to associate with the on-premises instance. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.on_premise_instance.register(
                ctx, instance_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.on_premise_instance.register instance_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="register_on_premises_instance",
        op_kwargs={
            "instanceName": instance_name,
            "iamSessionArn": iam_session_arn,
            "iamUserArn": iam_user_arn,
        },
    )
