"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub,
    ctx,
    deployment_id: str = None,
    lifecycle_event_hook_execution_id: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are BeforeAllowTraffic and AfterAllowTraffic. For Amazon ECS deployments, the available lifecycle hooks are BeforeInstall, AfterInstall, AfterAllowTestTraffic, BeforeAllowTraffic, and AfterAllowTraffic. Lambda validation functions return Succeeded or Failed. For more information, see AppSpec 'hooks' Section for an AWS Lambda Deployment  and AppSpec 'hooks' Section for an Amazon ECS Deployment.

    Args:
        deployment_id(str, optional):  The unique ID of a deployment. Pass this ID to a Lambda function that validates a deployment lifecycle event. . Defaults to None.
        lifecycle_event_hook_execution_id(str, optional):  The execution ID of a deployment's lifecycle hook. A deployment lifecycle hook is specified in the hooks section of the AppSpec file. . Defaults to None.
        status(str, optional): The result of a Lambda function that validates a deployment lifecycle event. Succeeded and Failed are the only valid values for status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.lifecycle_event_hook_execution_status.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.lifecycle_event_hook_execution_status.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="put_lifecycle_event_hook_execution_status",
        op_kwargs={
            "deploymentId": deployment_id,
            "lifecycleEventHookExecutionId": lifecycle_event_hook_execution_id,
            "status": status,
        },
    )
