"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the names of stored connections to GitHub accounts.

    Args:
        next_token(str, optional): An identifier returned from the previous ListGitHubAccountTokenNames call. It can be used to return the next set of names in the list. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.git_hub_account_token.name.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.git_hub_account_token.name.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="list_git_hub_account_token_names",
        op_kwargs={"nextToken": next_token},
    )
