"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, token_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a GitHub account connection.

    Args:
        token_name(str, optional): The name of the GitHub account connection to delete. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.git_hub_account_token.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.git_hub_account_token.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="delete_git_hub_account_token",
        op_kwargs={"tokenName": token_name},
    )
