"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, instance_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.

    Args:
        instance_names(List): The names of the on-premises instances about which to get information. The maximum number of instance names you can specify is 25.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.get.on_premise_instance.batch(
                ctx, instance_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.get.on_premise_instance.batch instance_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="batch_get_on_premises_instances",
        op_kwargs={"instanceNames": instance_names},
    )
