"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, deployment_id: str, instance_ids: List) -> Dict:
    r"""
    **Autogenerated function**

      This method works, but is deprecated. Use BatchGetDeploymentTargets instead.    Returns an array of one or more instances associated with a deployment. This method works with EC2/On-premises and AWS Lambda compute platforms. The newer BatchGetDeploymentTargets works with all compute platforms. The maximum number of instances that can be returned is 25.

    Args:
        deployment_id(str):  The unique ID of a deployment. .
        instance_ids(List): The unique IDs of instances used in the deployment. The maximum number of instance IDs you can specify is 25.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.get.deployment.instance.batch(
                ctx, deployment_id=value, instance_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.get.deployment.instance.batch deployment_id=value, instance_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="batch_get_deployment_instances",
        op_kwargs={"deploymentId": deployment_id, "instanceIds": instance_ids},
    )
