"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, application_name: str, deployment_group_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more deployment groups.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the applicable IAM user or AWS account.
        deployment_group_names(List): The names of the deployment groups.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.get.deployment.group.batch(
                ctx, application_name=value, deployment_group_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.get.deployment.group.batch application_name=value, deployment_group_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="batch_get_deployment_groups",
        op_kwargs={
            "applicationName": application_name,
            "deploymentGroupNames": deployment_group_names,
        },
    )
