"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, application_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more applications. The maximum number of applications that can be returned is 100.

    Args:
        application_names(List): A list of application names separated by spaces. The maximum number of application names you can specify is 100.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.get.application.init.batch(
                ctx, application_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.get.application.init.batch application_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="batch_get_applications",
        op_kwargs={"applicationNames": application_names},
    )
