"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, deployment_id: str = None, target_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns information about a deployment target.

    Args:
        deployment_id(str, optional):  The unique ID of a deployment. . Defaults to None.
        target_id(str, optional):  The unique ID of a deployment target. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.target.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.target.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="get_deployment_target",
        op_kwargs={"deploymentId": deployment_id, "targetId": target_id},
    )


async def list_all(
    hub,
    ctx,
    deployment_id: str = None,
    next_token: str = None,
    target_filters: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns an array of target IDs that are associated a deployment.

    Args:
        deployment_id(str, optional):  The unique ID of a deployment. . Defaults to None.
        next_token(str, optional):  A token identifier returned from the previous ListDeploymentTargets call. It can be used to return the next set of deployment targets in the list. . Defaults to None.
        target_filters(Dict, optional):  A key used to filter the returned targets. The two valid values are:    TargetStatus - A TargetStatus filter string can be Failed, InProgress, Pending, Ready, Skipped, Succeeded, or Unknown.     ServerInstanceLabel - A ServerInstanceLabel filter string can be Blue or Green.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.target.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.target.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="list_deployment_targets",
        op_kwargs={
            "deploymentId": deployment_id,
            "nextToken": next_token,
            "targetFilters": target_filters,
        },
    )
