"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, deployment_id: str, instance_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about an instance as part of a deployment.

    Args:
        deployment_id(str):  The unique ID of a deployment. .
        instance_id(str):  The unique ID of an instance in the deployment group. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.instance.get(
                ctx, deployment_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.instance.get deployment_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="get_deployment_instance",
        op_kwargs={"deploymentId": deployment_id, "instanceId": instance_id},
    )


async def list_all(
    hub,
    ctx,
    deployment_id: str,
    next_token: str = None,
    instance_status_filter: List = None,
    instance_type_filter: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

      The newer BatchGetDeploymentTargets should be used instead because it works with all compute types. ListDeploymentInstances throws an exception if it is used with a compute platform other than EC2/On-premises or AWS Lambda.    Lists the instance for a deployment associated with the IAM user or AWS account.

    Args:
        deployment_id(str):  The unique ID of a deployment. .
        next_token(str, optional): An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list. Defaults to None.
        instance_status_filter(List, optional): A subset of instances to list by status:    Pending: Include those instances with pending deployments.    InProgress: Include those instances where deployments are still in progress.    Succeeded: Include those instances with successful deployments.    Failed: Include those instances with failed deployments.    Skipped: Include those instances with skipped deployments.    Unknown: Include those instances with deployments in an unknown state.  . Defaults to None.
        instance_type_filter(List, optional): The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.instance.list_all(
                ctx, deployment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.instance.list_all deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="list_deployment_instances",
        op_kwargs={
            "deploymentId": deployment_id,
            "nextToken": next_token,
            "instanceStatusFilter": instance_status_filter,
            "instanceTypeFilter": instance_type_filter,
        },
    )
