"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"continue_": "continue"}


async def continue_(
    hub, ctx, deployment_id: str = None, deployment_wait_type: str = None
) -> None:
    r"""
    **Autogenerated function**

    For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.)

    Args:
        deployment_id(str, optional):  The unique ID of a blue/green deployment for which you want to start rerouting traffic to the replacement environment. . Defaults to None.
        deployment_wait_type(str, optional):  The status of the deployment's waiting period. READY_WAIT indicates that the deployment is ready to start shifting traffic. TERMINATION_WAIT indicates that the traffic is shifted, but the original target is not terminated. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.init.continue(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.init.continue
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="continue_deployment",
        op_kwargs={
            "deploymentId": deployment_id,
            "deploymentWaitType": deployment_wait_type,
        },
    )


async def create(
    hub,
    ctx,
    application_name: str,
    deployment_group_name: str = None,
    revision: Dict = None,
    deployment_config_name: str = None,
    description: str = None,
    ignore_application_stop_failures: bool = None,
    target_instances: Dict = None,
    auto_rollback_configuration: Dict = None,
    update_outdated_instances_only: bool = None,
    file_exists_behavior: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deploys an application revision through the specified deployment group.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
        deployment_group_name(str, optional): The name of the deployment group. Defaults to None.
        revision(Dict, optional):  The type and location of the revision to deploy. . Defaults to None.
        deployment_config_name(str, optional): The name of a deployment configuration associated with the IAM user or AWS account. If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, CodeDeployDefault.OneAtATime is used by default. Defaults to None.
        description(str, optional): A comment about the deployment. Defaults to None.
        ignore_application_stop_failures(bool, optional):  If true, then if an ApplicationStop, BeforeBlockTraffic, or AfterBlockTraffic deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if ApplicationStop fails, the deployment continues with DownloadBundle. If BeforeBlockTraffic fails, the deployment continues with BlockTraffic. If AfterBlockTraffic fails, the deployment continues with ApplicationStop.   If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.   During a deployment, the AWS CodeDeploy agent runs the scripts specified for ApplicationStop, BeforeBlockTraffic, and AfterBlockTraffic in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail.   If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use ignoreApplicationStopFailures to specify that the ApplicationStop, BeforeBlockTraffic, and AfterBlockTraffic failures should be ignored. . Defaults to None.
        target_instances(Dict, optional):  Information about the instances that belong to the replacement environment in a blue/green deployment. . Defaults to None.
        auto_rollback_configuration(Dict, optional): Configuration information for an automatic rollback that is added when a deployment is created. Defaults to None.
        update_outdated_instances_only(bool, optional):  Indicates whether to deploy to all instances or only to instances that are not running the latest application revision. . Defaults to None.
        file_exists_behavior(str, optional): Information about how AWS CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment. The fileExistsBehavior parameter takes any of the following values:   DISALLOW: The deployment fails. This is also the default behavior if no option is specified.   OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.   RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.init.create(ctx, application_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.init.create application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="create_deployment",
        op_kwargs={
            "applicationName": application_name,
            "deploymentGroupName": deployment_group_name,
            "revision": revision,
            "deploymentConfigName": deployment_config_name,
            "description": description,
            "ignoreApplicationStopFailures": ignore_application_stop_failures,
            "targetInstances": target_instances,
            "autoRollbackConfiguration": auto_rollback_configuration,
            "updateOutdatedInstancesOnly": update_outdated_instances_only,
            "fileExistsBehavior": file_exists_behavior,
        },
    )


async def get(hub, ctx, deployment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a deployment.   The content property of the appSpecContent object in the returned revision is always null. Use GetApplicationRevision and the sha256 property of the returned appSpecContent object to get the content of the deployment’s AppSpec file.

    Args:
        deployment_id(str):  The unique ID of a deployment associated with the IAM user or AWS account. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.init.get(ctx, deployment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.init.get deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="get_deployment",
        op_kwargs={"deploymentId": deployment_id},
    )


async def list_all(
    hub,
    ctx,
    application_name: str = None,
    deployment_group_name: str = None,
    external_id: str = None,
    include_only_statuses: List = None,
    create_time_range: Dict = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.

    Args:
        application_name(str, optional): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.  If applicationName is specified, then deploymentGroupName must be specified. If it is not specified, then deploymentGroupName must not be specified.  . Defaults to None.
        deployment_group_name(str, optional): The name of a deployment group for the specified application.  If deploymentGroupName is specified, then applicationName must be specified. If it is not specified, then applicationName must not be specified.  . Defaults to None.
        external_id(str, optional): The unique ID of an external resource for returning deployments linked to the external resource. Defaults to None.
        include_only_statuses(List, optional): A subset of deployments to list by status:    Created: Include created deployments in the resulting list.    Queued: Include queued deployments in the resulting list.    In Progress: Include in-progress deployments in the resulting list.    Succeeded: Include successful deployments in the resulting list.    Failed: Include failed deployments in the resulting list.    Stopped: Include stopped deployments in the resulting list.  . Defaults to None.
        create_time_range(Dict, optional): A time range (start and end) for returning a subset of the list of deployments. Defaults to None.
        next_token(str, optional): An identifier returned from the previous list deployments call. It can be used to return the next set of deployments in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="list_deployments",
        op_kwargs={
            "applicationName": application_name,
            "deploymentGroupName": deployment_group_name,
            "externalId": external_id,
            "includeOnlyStatuses": include_only_statuses,
            "createTimeRange": create_time_range,
            "nextToken": next_token,
        },
    )


async def stop(
    hub, ctx, deployment_id: str, auto_rollback_enabled: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Attempts to stop an ongoing deployment.

    Args:
        deployment_id(str):  The unique ID of a deployment. .
        auto_rollback_enabled(bool, optional):  Indicates, when a deployment is stopped, whether instances that have been updated should be rolled back to the previous version of the application revision. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.init.stop(ctx, deployment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.init.stop deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="stop_deployment",
        op_kwargs={
            "deploymentId": deployment_id,
            "autoRollbackEnabled": auto_rollback_enabled,
        },
    )
