"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    application_name: str,
    deployment_group_name: str,
    service_role_arn: str,
    deployment_config_name: str = None,
    ec2_tag_filters: List = None,
    on_premises_instance_tag_filters: List = None,
    auto_scaling_groups: List = None,
    trigger_configurations: List = None,
    alarm_configuration: Dict = None,
    auto_rollback_configuration: Dict = None,
    outdated_instances_strategy: str = None,
    deployment_style: Dict = None,
    blue_green_deployment_configuration: Dict = None,
    load_balancer_info: Dict = None,
    ec2_tag_set: Dict = None,
    ecs_services: List = None,
    on_premises_tag_set: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a deployment group to which application revisions are deployed.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
        deployment_group_name(str): The name of a new deployment group for the specified application.
        deployment_config_name(str, optional): If specified, the deployment configuration name can be either one of the predefined configurations provided with AWS CodeDeploy or a custom deployment configuration that you create by calling the create deployment configuration operation.  CodeDeployDefault.OneAtATime is the default deployment configuration. It is used if a configuration isn't specified for the deployment or deployment group. For more information about the predefined deployment configurations in AWS CodeDeploy, see Working with Deployment Configurations in CodeDeploy in the AWS CodeDeploy User Guide. Defaults to None.
        ec2_tag_filters(List, optional): The Amazon EC2 tags on which to filter. The deployment group includes EC2 instances with any of the specified tags. Cannot be used in the same call as ec2TagSet. Defaults to None.
        on_premises_instance_tag_filters(List, optional): The on-premises instance tags on which to filter. The deployment group includes on-premises instances with any of the specified tags. Cannot be used in the same call as OnPremisesTagSet. Defaults to None.
        auto_scaling_groups(List, optional): A list of associated Amazon EC2 Auto Scaling groups. Defaults to None.
        service_role_arn(str): A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to act on the user's behalf when interacting with AWS services.
        trigger_configurations(List, optional): Information about triggers to create when the deployment group is created. For examples, see Create a Trigger for an AWS CodeDeploy Event in the AWS CodeDeploy User Guide. Defaults to None.
        alarm_configuration(Dict, optional): Information to add about Amazon CloudWatch alarms when the deployment group is created. Defaults to None.
        auto_rollback_configuration(Dict, optional): Configuration information for an automatic rollback that is added when a deployment group is created. Defaults to None.
        outdated_instances_strategy(str, optional): Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision. If this option is set to UPDATE or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances. If this option is set to IGNORE, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions. Defaults to None.
        deployment_style(Dict, optional): Information about the type of deployment, in-place or blue/green, that you want to run and whether to route deployment traffic behind a load balancer. Defaults to None.
        blue_green_deployment_configuration(Dict, optional): Information about blue/green deployment options for a deployment group. Defaults to None.
        load_balancer_info(Dict, optional): Information about the load balancer used in a deployment. Defaults to None.
        ec2_tag_set(Dict, optional): Information about groups of tags applied to EC2 instances. The deployment group includes only EC2 instances identified by all the tag groups. Cannot be used in the same call as ec2TagFilters. Defaults to None.
        ecs_services(List, optional):  The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <clustername>:<servicename>. . Defaults to None.
        on_premises_tag_set(Dict, optional): Information about groups of tags applied to on-premises instances. The deployment group includes only on-premises instances identified by all of the tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters. Defaults to None.
        tags(List, optional):  The metadata that you apply to CodeDeploy deployment groups to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.group.create(
                ctx, application_name=value, deployment_group_name=value, service_role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.group.create application_name=value, deployment_group_name=value, service_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="create_deployment_group",
        op_kwargs={
            "applicationName": application_name,
            "deploymentGroupName": deployment_group_name,
            "deploymentConfigName": deployment_config_name,
            "ec2TagFilters": ec2_tag_filters,
            "onPremisesInstanceTagFilters": on_premises_instance_tag_filters,
            "autoScalingGroups": auto_scaling_groups,
            "serviceRoleArn": service_role_arn,
            "triggerConfigurations": trigger_configurations,
            "alarmConfiguration": alarm_configuration,
            "autoRollbackConfiguration": auto_rollback_configuration,
            "outdatedInstancesStrategy": outdated_instances_strategy,
            "deploymentStyle": deployment_style,
            "blueGreenDeploymentConfiguration": blue_green_deployment_configuration,
            "loadBalancerInfo": load_balancer_info,
            "ec2TagSet": ec2_tag_set,
            "ecsServices": ecs_services,
            "onPremisesTagSet": on_premises_tag_set,
            "tags": tags,
        },
    )


async def delete(hub, ctx, application_name: str, deployment_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a deployment group.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
        deployment_group_name(str): The name of a deployment group for the specified application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.group.delete(
                ctx, application_name=value, deployment_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.group.delete application_name=value, deployment_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="delete_deployment_group",
        op_kwargs={
            "applicationName": application_name,
            "deploymentGroupName": deployment_group_name,
        },
    )


async def get(hub, ctx, application_name: str, deployment_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a deployment group.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
        deployment_group_name(str): The name of a deployment group for the specified application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.group.get(
                ctx, application_name=value, deployment_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.group.get application_name=value, deployment_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="get_deployment_group",
        op_kwargs={
            "applicationName": application_name,
            "deploymentGroupName": deployment_group_name,
        },
    )


async def list_all(hub, ctx, application_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the deployment groups for an application registered with the IAM user or AWS account.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
        next_token(str, optional): An identifier returned from the previous list deployment groups call. It can be used to return the next set of deployment groups in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.group.list_all(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.group.list_all application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="list_deployment_groups",
        op_kwargs={"applicationName": application_name, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    application_name: str,
    current_deployment_group_name: str,
    new_deployment_group_name: str = None,
    deployment_config_name: str = None,
    ec2_tag_filters: List = None,
    on_premises_instance_tag_filters: List = None,
    auto_scaling_groups: List = None,
    service_role_arn: str = None,
    trigger_configurations: List = None,
    alarm_configuration: Dict = None,
    auto_rollback_configuration: Dict = None,
    outdated_instances_strategy: str = None,
    deployment_style: Dict = None,
    blue_green_deployment_configuration: Dict = None,
    load_balancer_info: Dict = None,
    ec2_tag_set: Dict = None,
    ecs_services: List = None,
    on_premises_tag_set: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about a deployment group.

    Args:
        application_name(str): The application name that corresponds to the deployment group to update.
        current_deployment_group_name(str): The current name of the deployment group.
        new_deployment_group_name(str, optional): The new name of the deployment group, if you want to change it. Defaults to None.
        deployment_config_name(str, optional): The replacement deployment configuration name to use, if you want to change it. Defaults to None.
        ec2_tag_filters(List, optional): The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names. Defaults to None.
        on_premises_instance_tag_filters(List, optional): The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names. Defaults to None.
        auto_scaling_groups(List, optional): The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them. To keep the Auto Scaling groups, enter their names. To remove Auto Scaling groups, do not enter any Auto Scaling group names. Defaults to None.
        service_role_arn(str, optional): A replacement ARN for the service role, if you want to change it. Defaults to None.
        trigger_configurations(List, optional): Information about triggers to change when the deployment group is updated. For examples, see Edit a Trigger in a CodeDeploy Deployment Group in the AWS CodeDeploy User Guide. Defaults to None.
        alarm_configuration(Dict, optional): Information to add or change about Amazon CloudWatch alarms when the deployment group is updated. Defaults to None.
        auto_rollback_configuration(Dict, optional): Information for an automatic rollback configuration that is added or changed when a deployment group is updated. Defaults to None.
        outdated_instances_strategy(str, optional): Indicates what happens when new EC2 instances are launched mid-deployment and do not receive the deployed application revision. If this option is set to UPDATE or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new EC2 instances. If this option is set to IGNORE, CodeDeploy does not initiate a deployment to update the new EC2 instances. This may result in instances having different revisions. Defaults to None.
        deployment_style(Dict, optional): Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer. Defaults to None.
        blue_green_deployment_configuration(Dict, optional): Information about blue/green deployment options for a deployment group. Defaults to None.
        load_balancer_info(Dict, optional): Information about the load balancer used in a deployment. Defaults to None.
        ec2_tag_set(Dict, optional): Information about groups of tags applied to on-premises instances. The deployment group includes only EC2 instances identified by all the tag groups. Defaults to None.
        ecs_services(List, optional):  The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format <clustername>:<servicename>. . Defaults to None.
        on_premises_tag_set(Dict, optional): Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.deployment.group.update(
                ctx, application_name=value, current_deployment_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.deployment.group.update application_name=value, current_deployment_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="update_deployment_group",
        op_kwargs={
            "applicationName": application_name,
            "currentDeploymentGroupName": current_deployment_group_name,
            "newDeploymentGroupName": new_deployment_group_name,
            "deploymentConfigName": deployment_config_name,
            "ec2TagFilters": ec2_tag_filters,
            "onPremisesInstanceTagFilters": on_premises_instance_tag_filters,
            "autoScalingGroups": auto_scaling_groups,
            "serviceRoleArn": service_role_arn,
            "triggerConfigurations": trigger_configurations,
            "alarmConfiguration": alarm_configuration,
            "autoRollbackConfiguration": auto_rollback_configuration,
            "outdatedInstancesStrategy": outdated_instances_strategy,
            "deploymentStyle": deployment_style,
            "blueGreenDeploymentConfiguration": blue_green_deployment_configuration,
            "loadBalancerInfo": load_balancer_info,
            "ec2TagSet": ec2_tag_set,
            "ecsServices": ecs_services,
            "onPremisesTagSet": on_premises_tag_set,
        },
    )
