"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, application_name: str, revision: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about an application revision.

    Args:
        application_name(str): The name of the application that corresponds to the revision.
        revision(Dict): Information about the application revision to get, including type and location.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.application.revision.get(
                ctx, application_name=value, revision=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.application.revision.get application_name=value, revision=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="get_application_revision",
        op_kwargs={"applicationName": application_name, "revision": revision},
    )


async def list_all(
    hub,
    ctx,
    application_name: str,
    sort_by: str = None,
    sort_order: str = None,
    s3_bucket: str = None,
    s3_key_prefix: str = None,
    deployed: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about revisions for an application.

    Args:
        application_name(str):  The name of an AWS CodeDeploy application associated with the IAM user or AWS account. .
        sort_by(str, optional): The column name to use to sort the list results:    registerTime: Sort by the time the revisions were registered with AWS CodeDeploy.    firstUsedTime: Sort by the time the revisions were first used in a deployment.    lastUsedTime: Sort by the time the revisions were last used in a deployment.    If not specified or set to null, the results are returned in an arbitrary order. . Defaults to None.
        sort_order(str, optional):  The order in which to sort the list results:     ascending: ascending order.    descending: descending order.   If not specified, the results are sorted in ascending order. If set to null, the results are sorted in an arbitrary order. Defaults to None.
        s3_bucket(str, optional):  An Amazon S3 bucket name to limit the search for revisions.   If set to null, all of the user's buckets are searched. . Defaults to None.
        s3_key_prefix(str, optional):  A key prefix for the set of Amazon S3 objects to limit the search for revisions. . Defaults to None.
        deployed(str, optional):  Whether to list revisions based on whether the revision is the target revision of a deployment group:     include: List revisions that are target revisions of a deployment group.    exclude: Do not list revisions that are target revisions of a deployment group.    ignore: List all revisions.  . Defaults to None.
        next_token(str, optional): An identifier returned from the previous ListApplicationRevisions call. It can be used to return the next set of applications in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.application.revision.list_all(
                ctx, application_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.application.revision.list_all application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="list_application_revisions",
        op_kwargs={
            "applicationName": application_name,
            "sortBy": sort_by,
            "sortOrder": sort_order,
            "s3Bucket": s3_bucket,
            "s3KeyPrefix": s3_key_prefix,
            "deployed": deployed,
            "nextToken": next_token,
        },
    )


async def register(
    hub, ctx, application_name: str, revision: Dict, description: str = None
) -> None:
    r"""
    **Autogenerated function**

    Registers with AWS CodeDeploy a revision for the specified application.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
        description(str, optional): A comment about the revision. Defaults to None.
        revision(Dict): Information about the application revision to register, including type and location.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.application.revision.register(
                ctx, application_name=value, revision=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.application.revision.register application_name=value, revision=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="register_application_revision",
        op_kwargs={
            "applicationName": application_name,
            "description": description,
            "revision": revision,
        },
    )
