"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, application_name: str, compute_platform: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an application.

    Args:
        application_name(str): The name of the application. This name must be unique with the applicable IAM user or AWS account.
        compute_platform(str, optional):  The destination platform type for the deployment (Lambda, Server, or ECS). Defaults to None.
        tags(List, optional):  The metadata that you apply to CodeDeploy applications to help you organize and categorize them. Each tag consists of a key and an optional value, both of which you define. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.application.init.create(ctx, application_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.application.init.create application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="create_application",
        op_kwargs={
            "applicationName": application_name,
            "computePlatform": compute_platform,
            "tags": tags,
        },
    )


async def delete(hub, ctx, application_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an application.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.application.init.delete(ctx, application_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.application.init.delete application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="delete_application",
        op_kwargs={"applicationName": application_name},
    )


async def get(hub, ctx, application_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about an application.

    Args:
        application_name(str): The name of an AWS CodeDeploy application associated with the IAM user or AWS account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.application.init.get(ctx, application_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.application.init.get application_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="get_application",
        op_kwargs={"applicationName": application_name},
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the applications registered with the IAM user or AWS account.

    Args:
        next_token(str, optional): An identifier returned from the previous list applications call. It can be used to return the next set of applications in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.application.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.application.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="list_applications",
        op_kwargs={"nextToken": next_token},
    )


async def update(
    hub, ctx, application_name: str = None, new_application_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Changes the name of an application.

    Args:
        application_name(str, optional): The current name of the application you want to change. Defaults to None.
        new_application_name(str, optional): The new name to give the application. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codedeploy.application.init.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codedeploy.application.init.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codedeploy",
        operation="update_application",
        op_kwargs={
            "applicationName": application_name,
            "newApplicationName": new_application_name,
        },
    )
