"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, repository_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about triggers configured for a repository.

    Args:
        repository_name(str): The name of the repository for which the trigger is configured.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.trigger.get_all(
                ctx, repository_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.trigger.get_all repository_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="get_repository_triggers",
        op_kwargs={"repositoryName": repository_name},
    )


async def put_multiple(hub, ctx, repository_name: str, triggers: List) -> Dict:
    r"""
    **Autogenerated function**

    Replaces all triggers for a repository. Used to create or delete triggers.

    Args:
        repository_name(str): The name of the repository where you want to create or update the trigger.
        triggers(List): The JSON block of configuration information for each trigger.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.trigger.put_multiple(
                ctx, repository_name=value, triggers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.trigger.put_multiple repository_name=value, triggers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="put_repository_triggers",
        op_kwargs={"repositoryName": repository_name, "triggers": triggers},
    )


async def test(hub, ctx, repository_name: str, triggers: List) -> Dict:
    r"""
    **Autogenerated function**

    Tests the functionality of repository triggers by sending information to the trigger target. If real data is available in the repository, the test sends data from the last commit. If no data is available, sample data is generated.

    Args:
        repository_name(str): The name of the repository in which to test the triggers.
        triggers(List): The list of triggers to test.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codecommit.repository.trigger.test(
                ctx, repository_name=value, triggers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codecommit.repository.trigger.test repository_name=value, triggers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codecommit",
        operation="test_repository_triggers",
        op_kwargs={"repositoryName": repository_name, "triggers": triggers},
    )
